<?php $__env->startSection('title', ' Blogs'); ?>

<?php $__env->startSection('main'); ?>
   <section class="mt-[120px] mx-[100px]">
    <?php if($blogs->count()): ?>
    <div class="relative w-full h-auto rounded-[10px] mb-10"> <!-- Added mb-10 for spacing between posts -->
        <div class="absolute flex flex-col justify-end rounded-b-[10px] items-center inset-0 pb-5 bg-gradient-to-t from-black/90">
            <p class="text-center text-white text-lg underline">TERBARU</p>
            <p class="text-center text-white text-xs mt-2.5"><?php echo e(Carbon\Carbon::parse($blogs[0]->created_at)->isoFormat('DD MM YYYY') ?? '25 November 2006'); ?></p>
            <h2 class="text-center text-white font-bold text-3xl leading-9 mt-2.5 mx-6"><?php echo e($blogs[0]->title); ?></h2>
            <p class="text-center text-white text-sm mx-[150px] mt-2.5 italic"><?php echo e($blogs[0]->summary); ?></p>
            <a href="/blog/<?php echo e($blogs[0]->slug); ?>">
                <div class="bg-white text-black text-lg font-bold py-2 px-6 rounded-[5px] mt-5">Selengkapnya</div>
            </a>
        </div>
        <img src="<?php echo e(asset($blogs[0]->image)); ?>" width="500" height="500" class="w-full h-auto rounded-[10px]" alt="">
    </div>
    <?php endif; ?>
</section>


    
    <section class="mx-[100px] mt-[40px]">
        <div class="">
            <h3 class=" font-bold text-xl text-center ">Berita Terbaru</h3>
        </div>
        <div class="grid grid-cols-4 gap-6 mt-[20px] ">
            <?php $__currentLoopData = $blogs->skip(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <!-- Blog Card -->
                    <div class="bg-white drop-shadow-md rounded-[10px]">
                       <a href="/blog/<?php echo e($blog->slug); ?>">
                         <img src="<?php echo e(asset($blog->image)); ?>" alt="" width="302" height="220" class=" w-full h-auto rounded-t-[10px]" loading="lazy" >
                       </a>

                        <div class="p-5 space-y-[5px]">
                            <a href=" /blog/<?php echo e($blog->slug); ?>">
                                <h3 class=" text-black text-sm font-bold line-clamp-2">
                                    <?php echo e($blog->title); ?>

                                </h3>
                            </a>

                            <div class="flex items-center gap-x-6">
                                <time class=" text-xs text-[#888888]"><?php echo e(Carbon\Carbon::parse($blogs[0]->created_at)->isoFormat('DD MM YYYY') ?? '25 November 2006'); ?></time>
                                <p class=" text-xs flex text-[#888888]"><i class="size-18 me-1" data-feather="message-square"></i> 
                                     <?php echo e($blog->comment->count()); ?> Komentar
                                </p>
                            </div>

                            <a href="/blog/<?php echo e($blog->slug); ?>">
                                <p class="text-[#4F4F4F] text-sm line-clamp-5">
                                    <?php echo e($blog->summary); ?>

                                </p>
                            </a>                        
                        </div>
                    </div>
                <!-- Blog Card End -->
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>      
        </div>
       <div class=" mt-7 ">
             <?php echo e($blogs->appends(request()->query())->links('components.layout.user.mypagination')); ?>

       </div>
    </section>

   
<?php $__env->stopSection(); ?>
<?php echo $__env->make('components.layout.user.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/zhekabaila/stemanika-laravel/resources/views/pages/user/blog.blade.php ENDPATH**/ ?>