<?php $__env->startSection('title', 'Fasilitas'); ?>

<?php $__env->startSection('links'); ?>
    <link rel="stylesheet"href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>

<?php $__env->stopSection(); ?>

                                                                                                                                                                      
<?php $__env->startSection('main'); ?>
    <section class=" mx-[100px] mt-[100px]">
        <div class="">
            <h1 class=" font-bold text-[32px]">Fasilitas</h1>
            <p class="text-[18px]">
                SMKN 1 Majalengka dilengkapi dengan fasilitas modern seperti ruang kelas yang nyaman, laboratorium komputer canggih, bengkel teknik untuk praktik, perpustakaan dengan koleksi lengkap, aula serbaguna, lapangan olahraga, serta ruang praktik khusus untuk setiap jurusan. Fasilitas ini mendukung kegiatan belajar mengajar yang optimal dan pengembangan keterampilan siswa.
            </p>
        </div>

        <!-- Fasilitas Start-->
        <div class=" mt-8 ">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-7">
                <?php $__currentLoopData = $fasilitas_umum; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fasilitas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="#" class="relative rounded-[10px] group overflow-hidden hover gap-x-4">
                        <img src="<?php echo e(asset($fasilitas['image'])); ?>" class="aspect-[5/3] object-cover object-center size-full scale-125 transition-all duration-500 group-hover:scale-100 ease-in-out" alt="">
                        <div class="absolute z-50 inset-0 text-white flex items-end justify-center pb-6 text-[18px] bg-gradient-to-t from-black/60 group-hover:from-black/70 group-hover:to-black/30 transition-all duration-500">
                            <h5 class="absolute bottom-6 group-hover:bottom-1/2 duration-500 font-semibold"><?php echo e($fasilitas['name']); ?></h5>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

    <section class="mt-[50px] bg-cover bg-no-repeat bg-center rounded-[10px]" style="background-image: url(<?php echo e(asset('images/bangunan_utama.png')); ?>)">
        <div class="bg-black/30 backdrop-blur-lg shadow-md p-5 rounded-[10px] w-full">
            <div class="w-full max-w-5xl mx-auto">
                <h3 class="text-center text-white text-lg font-bold">Jelajahi Sekolah Kami dari Mana Saja</h3>
                <p class="text-center text-white text-base font-normal mt-4">Ingin tahu lebih banyak tentang sekolah kami? Lihat langsung lingkungan belajar dan fasilitas kami melalui Virtual Tour. Jelajahi dari rumah Anda. Klik di sini untuk memulai.</p>
                <div class="flex justify-center mt-5">
                    <a href="https://vtour.smkn1majalengka.sch.id" target="_blank" class="text-black text-lg font-bold bg-white px-[30px] py-2.5 rounded-md">
                        mulai
                    </a>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
    new Swiper('.swiper', {
                spaceBetween: 10,
                slidesPerView: '5',
                loop: true,
                
                // Navigation arrows
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
            

            });
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('components.layout.user.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/zhekabaila/stemanika-laravel/resources/views/pages/user/fasilitas.blade.php ENDPATH**/ ?>