<?php $__env->startSection('title', 'Fasilitas'); ?>

<?php $__env->startSection('links'); ?>
    <link rel="stylesheet"href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>

<?php $__env->stopSection(); ?>

                                                                                                                                                                      
<?php $__env->startSection('main'); ?>
    <section class=" mx-[100px] mt-[100px]">
        <div class="">
            <h1 class=" font-bold text-[32px]">Ekstrakulikuler</h1>
            <p class="text-[18px]">
                SMKN 1 Majalengka menawarkan 16 ekstrakurikuler yang beragam, memberikan siswa kesempatan untuk mengembangkan bakat, keterampilan, dan karakter di luar akademik. Program ekstrakurikuler ini mencakup berbagai bidang seperti olahraga, seni, dan keterampilan praktis, mendukung pembentukan siswa yang berprestasi dan berkarakter.
            </p>
        </div>

        
        <div class="mt-[50px] grid grid-cols-2 gap-5">
           <?php $__currentLoopData = $ekstrakulikuler; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ekskul): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
            <a href="/eksrakulikuler/<?php echo e($ekskul->slug); ?>">
                <div class="flex gap-x-3 bg-white rounded-[10px] drop-shadow-lg overflow-hidden">
                    <img src="<?php echo e(asset($ekskul->image)); ?>" alt=""  width="209" height="138">
                    <div class="mt-2">
                        <h3 class=" font-semibold text-[18px]"><?php echo e($ekskul->name); ?></h3>
                        <p class=" text-[16px] text-[#4F4F4F] line-clamp-3 pe-1.5"><?php echo e($ekskul->description); ?></p>
                    </div>
                </div>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>

    <section class="mx-[100px] mt-[100px]">
        <h1 class="font-bold text-[32px] text-center mb-4">Galeri Prestasi</h1>
        <div class="grid grid-cols-4 gap-4">
                <?php for($i = 0; $i < 8; $i++): ?>
                    <div class="relative group overflow-hidden rounded-[10px] ">
                        <img src="<?php echo e(asset('images/bg-sekolah.jpg')); ?>" alt="" class=" object-cover object-center scale-105 group-hover:scale-125 transition-all duration-500" width="450" height="215"> 
                        <div class="absolute flex items-end justify-center inset-0 p-2 bottom-0 text-[12px] bg-gradient-to-t from-black/90 translate-y-20 group-hover:-translate-y-0 transition-all duration-500">
                            <p class="z-50 text-white text-center line-clamp-2">Lorem ipsum dolor sit amet consectetur adipisicing elit. Accusantium quas quae assumenda facere possimus similique.</p>
                        </div>
                    </div>
                <?php endfor; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
    new Swiper('.swiper', {
                spaceBetween: 10,
                slidesPerView: '5',
                loop: true,
                
                // Navigation arrows
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
            

            });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('components.layout.user.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/zhekabaila/stemanika-laravel/resources/views/pages/user/ekstrakulikuler.blade.php ENDPATH**/ ?>