@extends('components.layout.user.container')

@section('title', 'Beranda')

@section('links')

@endsection

{{-- Main Content --}}                                                                                                                                                                      
@section('main')
    <section id="hero" class="relative">
        <div class="relative w-full h-screen overflow-y-hidden">
            <div class="absolute flex items-center justify-center w-full h-full z-20 bg-gradient-to-t from-dark/90">
                <h2 class="desc">
                    <span class="block text-center text-white text-2xl font-normal">Selamat datang di</span>
                    <span class="block text-white text-center text-5xl font-bold mt-5">SMKN 1 Majalengka</span>
                </h2>
            </div>
            <img src="{{ asset('images/bg-sekolah.jpg') }}" alt="bangunan utama" width="500" height="500" class="hero w-full h-full object-cover object-center -z-20" loading="lazy">
        </div>
        <div class="flex justify-between items-center gap-x-9 absolute -bottom-20 z-20 px-[100px] w-full">
            <div class="flex flex-col gap-y-4 items-center justify-center bg-black/20 backdrop-blur-sm py-10 w-full">
                <h3 class="text-white text-4xl font-semibold">2rb+</h3>
                <p class="text-white text-base font-medium italic">Siswa/i</p>
            </div>
            <div class="flex flex-col gap-y-4 items-center justify-center bg-black/20 backdrop-blur-sm py-10 w-full">
                <h3 class="text-white text-4xl font-semibold">7+</h3>
                <p class="text-white text-base font-medium italic">Jurusan</p>
            </div>
            <div class="flex flex-col gap-y-4 items-center justify-center bg-black/20 backdrop-blur-sm py-10 w-full">
                <h3 class="text-white text-4xl font-semibold">70</h3>
                <p class="text-white text-base font-medium italic">Ruang Kelas</p>
            </div>
            <div class="flex flex-col gap-y-4 items-center justify-center bg-black/20 backdrop-blur-sm py-10 w-full">
                <h3 class="text-white text-4xl font-semibold">16</h3>
                <p class="text-white text-base font-medium italic">Ekstrakulikuler</p>
            </div>
        </div>
    </section>

    <section id="visi-misi" class="px-[100px] mt-52">
        <div class="flex items-center justify-between gap-5 bg-dark py-5 px-[30px] rounded-[10px]">
            <div>
                <h3 class="text-center text-white text-[32px] leading-[32px] font-bold">Visi</h3>
                <p class="text-center text-white text-base font-normal mt-2.5">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
            </div>
            <div class="h-56 w-2 bg-white"></div>
            <div>
                <h3 class="text-center text-white text-[32px] leading-[32px] font-bold">Misi</h3>
                <p class="text-center text-white text-base font-normal mt-2.5">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
            </div>
        </div>
    </section>

    <section id="berita" class="px-[100px] mt-52">
        <h2 class="text-center text-black text-3xl font-bold mb-7">Berita Terbaru</h2>
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-14">
            @foreach($blogs as $blog)
                <!-- Blog Card -->
                    <div class="bg-white drop-shadow-md rounded-[10px]">
                       <a href="/blogs/{{ $blog->slug }}">
                         <img src="{{ asset($blog->image) }}" alt="" width="302" height="220" class=" w-full h-auto rounded-t-[10px]" loading="lazy" >
                       </a>

                        <div class="p-5 space-y-[5px]">
                            <a href=" /blogs/{{ $blog->slug }}">
                                <h3 class=" text-black text-sm font-bold line-clamp-2">
                                    {{ $blog->title }}
                                </h3>
                            </a>

                            <div class="flex items-center gap-x-6">
                                <time class=" text-xs text-[#888888]">{{ Carbon\Carbon::parse($blogs[0]->created_at)->isoFormat('DD MM YYYY') ?? '25 November 2006' }}</time>
                                <p class=" text-xs flex text-[#888888]"><i class="size-18 me-1" data-feather="message-square"></i> 
                                     {{ $blog->comment->count() }} Komentar
                                </p>
                            </div>

                            <a href="/blogs/{{ $blog->slug }}">
                                <p class="text-[#4F4F4F] text-sm line-clamp-5">
                                    {{ $blog->summary }}
                                </p>
                            </a>                        
                        </div>
                    </div>
                <!-- Blog Card End -->
            @endforeach      
        </div>
    </section>

    <section id="fasilitas" class="px-[100px] mt-52">
        <h2 class="text-center text-black text-3xl font-bold mb-7">Fasilitas</h2>
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-14">
            @foreach ($fasilitas as $fasiliti)
                <a href="#" class="relative bg-dark rounded-[10px] group overflow-hidden" key="{{ $fasiliti->id }}">
                    <img src="{{ asset($fasiliti->image) }}" alt="" class="object-cover object-center w-full h-auto rounded-[5px] aspect-video scale-150 group-hover:scale-100 transition-all duration-300 ease-in-out" loading="lazy">
                    <div class="absolute inset-0 py-6 flex items-end justify-center bg-gradient-to-t from-dark/90">
                        <h3 class="text-center text-white text-lg font-medium">{{ $fasiliti->name }}</h3>
                    </div>
                </a>
            @endforeach
            <a href="#" class="flex items-center justify-center bg-dark rounded-[10px] group overflow-hidden" key="{{ $fasiliti->id }}">
                <h3 class="text-center text-white text-lg font-medium">Selanjutnya >></h3>
            </a>
        </div>
    </section>

    <section class="mx-[100px] mt-52 bg-cover bg-no-repeat bg-center rounded-[10px]" style="background-image: url({{ asset('images/bangunan_utama.png') }})">
        <div class="bg-black/30 backdrop-blur-lg shadow-md px-5 py-14 rounded-[10px] w-full">
            <div class="w-full max-w-5xl mx-auto">
                <h3 class="text-center text-white text-lg font-bold">Jelajahi Sekolah Kami dari Mana Saja</h3>
                <p class="text-center text-white text-base font-normal mt-6">Ingin tahu lebih banyak tentang sekolah kami? Lihat langsung lingkungan belajar dan fasilitas kami melalui Virtual Tour. Jelajahi dari rumah Anda. Klik di sini untuk memulai.</p>
                <div class="flex justify-center mt-7">
                    <a href="https://vtour.smkn1majalengka.sch.id" target="_blank" class="text-black text-lg font-bold bg-white px-[30px] py-2 rounded-md">
                        mulai
                    </a>
                </div>
            </div>
        </div>
    </section>
@endsection
{{-- Main Content --}}

@section('scripts')
@endsection