@extends('components.layout.user.container')

@section('title', 'Fasilitas')

@section('links')
    <link rel="stylesheet"href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>

@endsection

{{-- Main Content --}}                                                                                                                                                                      
@section('main')
    <section class=" mx-[100px] mt-[100px]">
        <div class="">
            <h1 class=" font-bold text-[32px]">Ekstrakulikuler</h1>
            <p class="text-[18px]">
                SMKN 1 Majalengka menawarkan 16 ekstrakurikuler yang beragam, memberikan siswa kesempatan untuk mengembangkan bakat, keterampilan, dan karakter di luar akademik. Program ekstrakurikuler ini mencakup berbagai bidang seperti olahraga, seni, dan keterampilan praktis, mendukung pembentukan siswa yang berprestasi dan berkarakter.
            </p>
        </div>

        
        <div class="mt-[50px] grid grid-cols-2 gap-5">
           @foreach($ekstrakulikuler as $ekskul) 
            <a href="/eksrakulikuler/{{ $ekskul->slug }}">
                <div class="flex gap-x-3 bg-white rounded-[10px] drop-shadow-lg overflow-hidden">
                    <img src="{{ asset($ekskul->image) }}" alt=""  width="209" height="138">
                    <div class="mt-2">
                        <h3 class=" font-semibold text-[18px]">{{ $ekskul->name }}</h3>
                        <p class=" text-[16px] text-[#4F4F4F] line-clamp-3 pe-1.5">{{ $ekskul->description }}</p>
                    </div>
                </div>
            </a>
            @endforeach
        </div>
    </section>

    <section class="mx-[100px] mt-[100px]">
        <h1 class="font-bold text-[32px] text-center mb-4">Galeri Prestasi</h1>
        <div class="grid grid-cols-4 gap-4">
                @for($i = 0; $i < 8; $i++)
                    <div class="relative group overflow-hidden rounded-[10px] ">
                        <img src="{{ asset('images/bg-sekolah.jpg') }}" alt="" class=" object-cover object-center scale-105 group-hover:scale-125 transition-all duration-500" width="450" height="215"> 
                        <div class="absolute flex items-end justify-center inset-0 p-2 bottom-0 text-[12px] bg-gradient-to-t from-black/90 translate-y-20 group-hover:-translate-y-0 transition-all duration-500">
                            <p class="z-50 text-white text-center line-clamp-2">Lorem ipsum dolor sit amet consectetur adipisicing elit. Accusantium quas quae assumenda facere possimus similique.</p>
                        </div>
                    </div>
                @endfor
        </div>
    </section>
@endsection
{{-- Main Content --}}

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
    new Swiper('.swiper', {
                spaceBetween: 10,
                slidesPerView: '5',
                loop: true,
                
                // Navigation arrows
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
            

            });
</script>
@endsection