@extends('components.layout.admin.container')

@section('title', 'Ekstrakulikuler')

@section('links')
    <style>
        .ck-editor__editable[role="textbox"] {
            /* Editing area */
            min-height: 200px;
        }
        .ck-content .image {
            /* Block images */
            max-width: 80%;
            margin: 20px auto;
        }
    </style>
@endsection

@section('main')
    <section class="mx-[100px] my-[150px]">
        <div class="flex"> 
            <p class="font-base flex items-center text-xl font-medium">
                <a href="{{ url()->previous() }}">
                    <i class="bg-black flex items-center justify-center p-1 size-auto rounded-[5px] text-white me-4" data-feather="chevron-left"></i>
                </a>
                Kembali
            </p>
        </div>

        @if ($errors->any())
            <div>
                <h3 class="text-red-500 text-xl font-bold">Beberapa error ketika mencoba menyimpan data:</h3>
                <ol class="list-decimal list-inside">
                    @foreach ($errors->all() as $error)
                        <li class="text-red-500 text-base font-medium">{{ $error }}</li>
                    @endforeach
                </ol>
            </div>
        @endif

        <form method="POST" action="{{ route('admin.ekstrakulikuler.update', $ekstrakulikuler->id) }}" id="container" enctype="multipart/form-data" class="grid grid-cols-1 gap-6 mt-14">
            @csrf @method('PUT')
            <div class="space-y-1.5">
                <div class="aspec-[4/3] max-w-6xl mx-auto">
                    <img src="{{ asset($ekstrakulikuler->image) }}" alt="{{ $ekstrakulikuler->name . ' Image' }}" id="image_preview" width="1152" height="500" loading="lazy" class="object-center object-cover size-full rounded-md">
                </div>
                <label for="image" class="text-dark font-medium text-base block">cover image</label>
                <input type="file" accept=".png, .svg, .jpeg, jpg" name="image" id="image" onchange="previewLogo(event)" class="border border-[#ccced1] p-2 rounded w-full">
            </div>
            <div class="space-y-1.5">
                <label for="name" class="text-dark font-medium text-base block">title</label>
                <input type="text" name="name" id="name" class="border border-[#ccced1] p-2 rounded w-full" value="{{ $ekstrakulikuler->name }}">
            </div>
            <div class="space-y-1.5">
                <label for="description" class="text-dark font-medium text-base block">description</label>
                <textarea type="text" name="description" id="description" cols="30" rows="4" class="border border-[#ccced1] p-2 rounded w-full">{{ $ekstrakulikuler->description }}</textarea>
            </div>
            <div class="flex items-center gap-x-4">
                <label for="show" class="text-dark font-medium text-xl block">show</label>
                <input type="checkbox" name="show" id="show" class="size-4 accent-green-400" {{ $ekstrakulikuler->show ? 'checked' : '' }}>
            </div>
            <div class="space-y-1.5">
                <button type="submit" class="bg-dark px-6 py-1.5 rounded-md text-white text-base font-medium">submit</button>
            </div>
        </form>
    </section>
@endsection

@section('scripts')
    <script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>

    <script>
        function previewLogo(event) {
            const input = event.target;
            const preview = document.getElementById('image_preview');

            if (input.files && input.files[0]) {
                const reader = new FileReader();

                reader.onload = function (e) {
                    preview.src = e.target.result;
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

    <script>
        class MyUploadAdapter {
            constructor( loader ) {
                this.loader = loader;
            }
            upload() {
                return this.loader.file
                    .then( file => new Promise( ( resolve, reject ) => {
                        this._initRequest();
                        this._initListeners( resolve, reject, file );
                        this._sendRequest( file );
                    } ) );
            }
            abort() {
                if ( this.xhr ) {
                    this.xhr.abort();
                }
            }
            _initRequest() {
                const xhr = this.xhr = new XMLHttpRequest();

                xhr.open( 'POST', "{{ route('ckeditor.upload') }}", true );
                xhr.setRequestHeader( 'x-csrf-token', "{{ csrf_token() }}" );
                xhr.responseType = 'json';
            }
            _initListeners( resolve, reject, file ) {
                const xhr = this.xhr;
                const loader = this.loader;
                const genericErrorText = `Couldn't upload file: ${ file.name }.`;

                xhr.addEventListener( 'error', () => reject( genericErrorText ) );
                xhr.addEventListener( 'abort', () => reject() );
                xhr.addEventListener( 'load', () => {
                    const response = xhr.response;
                    if ( !response || response.error ) {
                        return reject( response && response.error ? response.error.message : genericErrorText );
                    }
                    resolve( {
                        default: response.url
                    } );
                } );
                if ( xhr.upload ) {
                    xhr.upload.addEventListener( 'progress', evt => {
                        if ( evt.lengthComputable ) {
                            loader.uploadTotal = evt.total;
                            loader.uploaded = evt.loaded;
                        }
                    } );
                }
            }
            _sendRequest(file) {
                const data = new FormData();
                data.append('upload', file);

                this.xhr.send(data);
            }
        }

        function MyCustomUploadAdapterPlugin(editor) {
            editor.plugins.get('FileRepository').createUploadAdapter = ( loader ) => {
                return new MyUploadAdapter( loader );
            };
        }

        ClassicEditor
            .create( document.querySelector( '#body' ), {
                extraPlugins: [ MyCustomUploadAdapterPlugin ],
            } )
            .catch( error => {
                console.log( error );
            });

    </script>
@endsection