<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@yield('title') | SMK Negeri 1 Majalengka (Stemanika)</title>
    <link rel="stemanika icon" href="{{ asset('images/logo_smk.png') }}" type="image/png">
    <script src="https://unpkg.com/feather-icons"></script>
    @yield('links')
    @env('production')
        <link rel="stylesheet" href="{{ asset('build/assets/global.css') }}">
    @else
        @vite('resources/css/global.css')
    @endenv
    <style>
        .size-18 {
            width: 16px;
            height: 16px;
        }
    </style>
</head>
<body>
    <x-layout.admin.navbar />

    <main>
        @yield('main')
    </main>

    @yield('scripts')

    @env('production')
        <script src="{{ asset('build/assets/main.js') }}"></script>
    @else
        @vite('resources/js/main.js')
    @endenv
    <script>
        feather.replace();

        const navbar = document.getElementById("navbar");

        window.addEventListener("scroll", (e) => {
            if (window.scrollY > 500) {
                navbar.classList.add("bg-opacity-50");
                navbar.classList.add("backdrop-blur-md");
                navbar.classList.add("shadow-lg");
            } else {
                navbar.classList.remove("bg-opacity-50");
                navbar.classList.remove("backdrop-blur-md");
                navbar.classList.remove("shadow-lg");
            }
        });
    </script>
</body>
</html>