<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FasilitasSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [];

        for ($i = 1; $i <= 120; $i++) {
            $data[] = [
                'id' => $i,
                'image' => 'https://res.cloudinary.com/dhc8yfgda/image/upload/v1734172491/STEMANIKA_WEBSITE/lmtpx7vksmwrirpt5zza.png',
                'name' => 'fasilitas' . $i,
                'slug' => 'fasilitas-' . $i,
                'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Odit a libero molestias autem consectetur inventore repellat, maxime facilis commodi quia. Hic cum esse, enim molestiae et ab inventore consectetur quam veritatis iure exercitationem. At ullam est corporis nam? Voluptates nisi sunt quas. Ipsa reprehenderit, nulla iusto beatae quis illum distinctio?',
                'show' => $i % 2 === 0 ? true : false
            ];
        }

        DB::table('fasilitas')->insert($data);
    }
}
