<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BlogSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [];

        for ($i = 1; $i <= 120; $i++) {
            $data[] = [
                'id' => $i,
                'slug' => 'contoh-post-ke-' . $i,
                'image' => 'https://res.cloudinary.com/dhc8yfgda/image/upload/v1734173633/STEMANIKA_WEBSITE/BLOG/afnfk1hc8qlqk8zw9jax.png',
                'title' => 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Quaerat, iste! Est iste id iusto maiores adipisci at quo quibusdam quidem? ' . $i,
                'summary' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Odit a libero molestias autem consectetur inventore repellat, maxime facilis commodi quia. Hic cum esse, enim molestiae et ab inventore consectetur quam veritatis iure exercitationem. At ullam est corporis nam? Voluptates nisi sunt quas. Ipsa reprehenderit, nulla iusto beatae quis illum distinctio?',
                'body' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Doloribus perspiciatis labore nulla praesentium dicta consectetur rerum totam, quod illo officiis molestias, adipisci modi voluptate debitis cupiditate illum dignissimos, id atque veniam. Odio, voluptatibus! Libero vitae impedit illo officiis, porro esse itaque consequuntur tempore dolorem laboriosam, nisi obcaecati ex ea aliquam quas asperiores voluptatem, labore rerum dicta similique maiores ullam reiciendis?',
                'show' => $i % 2 === 0 ? true : false,
                'user_id' => $i % 2 === 0 ? '2' : '1'
            ];
        }

        DB::table('blogs')->insert($data);
    }
}
