<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fasilitas extends Model
{
    use HasFactory, HasUuids;

    protected $guarded = ['id'];

    protected $table = 'fasilitas';

    protected $keyType = 'string';

    protected $fillable = [
        'image',
        'name',
        'description',
        'show',
        'slug'
    ];

    private static $fasilitas_umum = [
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Gedung Utama',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '1'
        ],
        [
            'image' =>  'images/bangunan_utama.png',
            'name' => 'Ruang Guru',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' =>  'images/bangunan_utama.png',
            'name' => 'Lapangan Upacara',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '1'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Lapangan Sepak Bola',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Lapangan Basket',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '1'
        ],
        [
            'image' =>  'images/bangunan_utama.png',
            'name' => 'Lapangan Voli',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Lapangan Badminton',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Kantin',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '1'
        ],
        [
            'image' =>  'images/bangunan_utama.png',
            'name' => 'Koperasi Siswa',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'SPW',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '1'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Bussiness Center',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Koperasi Pegawai',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Toilet',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' =>  'images/bangunan_utama.png',
            'name' => 'Masjid',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' =>  'images/bangunan_utama.png',
            'name' => 'Ruang Kelas',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Aula Bawah',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bangunan_utama.png',
            'name' => 'Ruang Pertemuan Lantai 2',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' =>  'images/bangunan_utama.png',
            'name' => 'Perpustakaan',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
    ];

    public static function fasilitas_umum() {
        return collect (self::$fasilitas_umum);
    }

    private static $fasilitas_jurusan = [
        [
            'image' => 'images/bg-sekolah.jpg',
            'name' => 'Bengkel DPIB',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '1'
        ],
        [
            'image' =>  'images/bg-sekolah.jpg',
            'name' => 'Bengkel TKL',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' =>  'images/bg-sekolah.jpg',
            'name' => 'Bengkel TPM',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '1'
        ],
        [
            'image' => 'images/bg-sekolah.jpg',
            'name' => 'Bengkel TSM',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bg-sekolah.jpg',
            'name' => 'Bengkel TKR',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '1'
        ],
        [
            'image' =>  'images/bg-sekolah.jpg',
            'name' => 'Bengkel RPL',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        [
            'image' => 'images/bg-sekolah.jpg',
            'name' => 'Bengkel TKJ',
            'description' => 'Lorem, ipsum dolor sit amet consectetur adipisicing elit. Numquam, repellat, veniam accusamus quam cupiditate quidem facere architecto natus, magnam minus mollitia? Dolores, asperiores tempora cum reiciendis vitae excepturi dolorem adipisci?',
            'show' => '2'
        ],
        
    ];

    public static function fasilitas_jurusan() {
        return collect (self::$fasilitas_jurusan);
    }
}
