<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreJurusan extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'logo' => ['required', 'mimes:png,jpg,jpeg,svg'],
            'name' => ['required', 'string', 'max:255', 'unique:jurusan,name'],
            'description' => ['required', 'string'],
        ];
    }

    public function messages(): array
    {
        return [
            'logo.required' => ':attribute dibutuhkan',
            'logo.mimes' => ':attribute hanya dapat bertipe: png, jpg, jpeg, svg',

            'name.required' => ':attribute dibutuhkan',
            'name.string' => ':attribute harus berupa teks',
            'name.string' => ':attribute tidak boleh melebihi 255 karakter',
            'name.unique' => ':attribute sudah tersedia',

            'description.required' => ':attribute dibutuhkan',
            'description.string' => ':attribute harus berupa teks',
        ];
    }
}
