<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBlog extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title' => ['required', 'string', 'max:255', 'unique:blogs,title'],
            'body' => ['required', 'string'],
            'summary' => ['required', 'string'],
            'image' => ['required', 'mimes:png,jpg,svg,jpeg']
        ];
    }

    public function messages(): array
    {
        return [
            'title.required' => ':attribute dibutuhkan',
            'title.string' => ':attribute harus berupa teks',
            'title.max' => ':attribute tidak boleh melebihi 255 karakter',
            'title.unique' => ':attribute sudah digunakan',

            'body.required' => ':attribute dibutuhkan',
            'body.string' => ':attribute harus berupa teks',

            'summary.required' => ':attribute dibutuhkan',
            'summary.string' => ':attribute harus berupa teks',

            'image.required' => ':attribute dibutuhkan',
            'image.mimes' => ':attribute hanya dapat bertipe: png, jpg, jpeg, svg',
        ];
    }
}
