<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class BlogUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $id = $this->route('id');

        return [
            'title' => ['required', 'string', 'max:255', Rule::unique('blogs', 'title')->ignore($id)],
            'image' => ['nullable', 'mimes:png,jpg,svg,jpeg'],
            'body' => ['required', 'string'],
            'summary' => ['required', 'string'],
            'show' => ['nullable'],
        ];
    }
}
