<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AuthLogin extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'email' => ['required', 'string', 'email', 'max:255'],
            'password' => ['required', 'string', 'max:255']
        ];
    }

    public function messages(): array
    {
        return [
            'email.required' => ':attribute dibutuhkan',
            'email.string' => ':attribute harus berupa teks',
            'email.email' => ':attribute harus berupa email',
            'email.max' => ':attribute tidak boleh melebihi 255 karakter',

            'password.required' => ':attribute dibutuhkan',
            'password.string' => ':attribute harus berupa teks',
            'password.max' => ':attribute tidak boleh melebihi 255 karakter',
        ];
    }
}
