<?php

namespace App\Http\Controllers;

use App\Models\Article;
use App\Models\Blog;
use Illuminate\Http\Request;

class CkeditorUploadController extends Controller
{
    public function upload(Request $request)
    {
        try {
            $blog = new Blog();

            $blog->id = 0;
            $blog->exists = true;

            //! Ganti APP_URL jadi agar bisa mengambil gambar yang dikirimkan di ckeditor http://127.0.0.1:8000
            $images = $blog->addMediaFromRequest('upload')->toMediaCollection('images');

            return response()->json([
                'url' => $images->getUrl()
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => [
                    'message' => $e->getMessage()
                ],
            ]);
        }
    }
}
