<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Mail\WebsiteMail;
use App\Models\Subscriber;
use Illuminate\Support\Facades\Mail;

class AdminSubscriberController extends Controller
{
    public function show_all()
    {
        $subscribers = Subscriber::where('status', 'active')->get();
        return view('subscribe_all', compact('subscribers'));
    }

    public function send_email_submit(Request $request)
    {
        $request->validate([
            'subject' => 'required',
            'message' => 'required'
        ]);

        $subject = $request->subject;
        $message = $request->message;

        $subscribers = Subscriber::where('status', 'active')->get();
        foreach ($subscribers as $row) {
            Mail::to($row->email)->send(new WebsiteMail($subject, $message));
        }

        return redirect()->back()->with('success', 'Email is Sent Successfully.');
    }
}
