<?php

namespace App\Helper;

use App\Mail\NewsMail;
use App\Models\Subscriber;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use CloudinaryLabs\CloudinaryLaravel\Facades\Cloudinary;

class CommonHelper
{
    public static function storeImage($image, $folder)
    {
        return Cloudinary::upload($image, [
            'folder' => 'STEMANIKA_WEBSITE/' . $folder,
        ])->getSecurePath();
    }

    public static function deleteImage($url, $folder)
    {
        $publid_id = CommonHelper::getPublicIdFromUrl($url, $folder);
        return Cloudinary::destroy($publid_id);
    }

    public static function updateImage($newImage, $oldPublicId, $folder)
    {
        $publid_id = CommonHelper::getPublicIdFromUrl($oldPublicId, $folder);
        Cloudinary::destroy($publid_id); // Hapus file lama
        return CommonHelper::storeImage($newImage, $folder); // Unggah file baru
    }

    public static function getPublicIdFromUrl($url, $folder)
    {
        // Mengambil path dari URL
        $path = parse_url($url, PHP_URL_PATH); // Mengambil path, contoh: /image/upload/v1734073785/avzpnb9acuvz3w5j3jbd.jpg

        // Cari posisi "/upload/" dalam path
        $uploadPos = strpos($path, '/upload/');
        if ($uploadPos === false) {
            return null; // Jika "/upload/" tidak ditemukan, kembalikan null
        }

        // Ambil bagian setelah "/upload/"
        $publicIdPath = substr($path, $uploadPos + strlen('/upload/'));

        // Ambil hanya segmen terakhir (tanpa folder atau versi)
        $segments = explode('/', $publicIdPath);
        $filenameWithExtension = end($segments);

        // Hapus ekstensi file dari segmen terakhir
        $publicId = pathinfo($filenameWithExtension, PATHINFO_FILENAME);

        return 'STEMANIKA_WEBSITE/' . $folder . '/' . $publicId;
    }

    public static function generateSlug($string): string
    {
        return Str::slug($string, '-');
    }

    public static function sendAllSubs(string $subjek, string $title, string $message, string $link): void
    {
        $subscribers = Subscriber::where('status', 'active')->get();

        foreach ($subscribers as $row) {
            Mail::to($row->email)->send(new NewsMail($subjek, $title, $message, $link, $row->email));
        }
    }
}
